﻿using System;
using System.Linq;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;

namespace Kolory
{
    public partial class Form1 : Form
    {
        Graphics g;
        Bitmap bmp;
        Point poprzedniPunkt;

        public Form1()
        {
            InitializeComponent();            

            bmp = new Bitmap(pictureBox1.Width, pictureBox1.Height);            
            g = Graphics.FromImage(bmp);            
            g.Clear(Color.White);
            pictureBox1.Image = bmp;
        }

        private void pictureBox1_MouseDown(object sender, MouseEventArgs e)
        {
            const int promien = 1;
            g.FillEllipse(
                new SolidBrush(panelWyboruKoloru1.Kolor), 
                e.X - promien, e.Y - promien, 2 * promien, 2 * promien);
            pictureBox1.Image = bmp;
            
            //do rysowania linii
            poprzedniPunkt.X = e.X;
            poprzedniPunkt.Y = e.Y;                        
        }

        private void pictureBox1_MouseMove(object sender, MouseEventArgs e)
        {            
            if (e.Button != MouseButtons.Left) return;

            const float szerokosc = 2f;
            g.DrawLine(
                new Pen(panelWyboruKoloru1.Kolor, szerokosc),
                poprzedniPunkt.X, poprzedniPunkt.Y, 
                e.X, e.Y);
            pictureBox1.Image = bmp;

            poprzedniPunkt.X = e.X;
            poprzedniPunkt.Y = e.Y;                        
        }

        private void menuItem1_Click(object sender, EventArgs e)
        {
            panelWyboruKoloru1.Visible = !panelWyboruKoloru1.Visible;
            menuItem1.Text = (!panelWyboruKoloru1.Visible)?"Kolor":"Ukryj";
        }

        private void menuItem3_Click(object sender, EventArgs e)
        {
            Close();
        }

        private void Form1_Closing(object sender, CancelEventArgs e)
        {
            DialogResult wybor = MessageBox.Show(
                "Czy na pewno chcesz zakończyć działanie programu?",
                "Zakończenie programu", MessageBoxButtons.YesNo,
                MessageBoxIcon.Question, MessageBoxDefaultButton.Button2);
            e.Cancel = (wybor == DialogResult.No);
        }

        private void menuItem5_Click(object sender, EventArgs e)
        {
            if (saveFileDialog1.ShowDialog() == DialogResult.OK)
            {
                bmp.Save(
                    saveFileDialog1.FileName,
                    System.Drawing.Imaging.ImageFormat.Bmp);
            }

        }

        private void menuItem6_Click(object sender, EventArgs e)
        {
            g.Clear(Color.White);
            pictureBox1.Image = bmp;
        }
    }
}